#n_part must be divisible by 4

set gamma [lindex $::argv 0]
set dt [lindex $::argv 1]
set L_MT [lindex $::argv 2]
set B [lindex $::argv 3]
set dx [lindex $::argv 4]
set bead_size [lindex $::argv 5]
set T [lindex $::argv 6]
set nsteps [lindex $::argv 7]
set n_part [lindex $::argv 8]
set kstretch [lindex $::argv 9]
set kbead [lindex $::argv 10]
set Smax [lindex $::argv 11]
set istest [lindex $::argv 12]

set box_l [expr $L_MT * 4]

set filename "buckling-gamma"
append filename $gamma "_dt"
append filename $dt "_L"
append filename $L_MT "_B"
append filename $B "_dx"
append filename $dx "_bead"
append filename $bead_size "_T"
append filename $T "_nsteps"
append filename $nsteps "_n"
append filename $n_part "_kstretch"
append filename $kstretch "_kbead"
append filename $kbead ".txt"

if {$istest == "test"} { set filename "test" }


set dl [expr $L_MT/$n_part]

set pos_left [expr $box_l/4. + $box_l/16.]
set pos_right0 [expr $box_l/4. + 3*$box_l/16.]
set sep0 [expr $box_l/8.]

set seed [pid]
for {set i 0} {$i< [setmd n_nodes]} {incr i} {
        lappend Seeds [expr $seed + $i]
}
eval t_random seed $Seeds


setmd box_l $box_l $box_l 1
setmd periodic 0 0 0
setmd time_step $dt
setmd skin 0.1
integrate set nvt
thermostat langevin $T $gamma

set tstart [setmd time]

inter 0 harmonic $kstretch [expr $dl]
inter 1 angle_harmonic [expr $B*$n_part / $L_MT] 
# make sure, e.g that L_MT is float!
inter 2 angle_harmonic 1000 [expr [PI]/2]
#inter 3 harmonic 1000000 10
inter 4 harmonic $kbead [expr $bead_size]

part 0 pos $pos_left [expr $box_l/2. - $bead_size] 0.5 mass 10000 type 2

for {set i 1} { $i <= $n_part } {incr i} {
set posx [expr $box_l/4.+ $i* $dl]
set posy [expr $box_l/2. ]
set posz 0.5
part [expr $i] pos [expr $posx] [expr $posy] [expr $posz] mass 10000 type 1
}

part [expr $n_part+1] pos $pos_right0 [expr $box_l/2. - $bead_size] 0.5 mass 10000 type 0


for {set i 1} { $i < $n_part } {incr i} {
part $i bond 0 [expr $i+1]
}

for {set i 2} { $i < $n_part } {incr i} {
part $i bond 1 [expr $i-1] [expr $i+1]
}

part 0 bond 4 [expr $n_part/4]
part [expr $n_part+1] bond 4 [expr 3*$n_part/4]

part [expr $n_part/4] bond 2 [expr $n_part/4-1] 0 
part [expr 3*$n_part/4] bond 2 [expr 3*$n_part/4+1] [expr $n_part+1]

#for bc, increment these by 1
#part [expr $n_part+1] pos [expr $box_l/4.] [expr $box_l/2. + 10] [expr $box_l/2.] type 1
#part [expr $n_part+2] pos [expr $box_l/2.] [expr $box_l/2. + 10] [expr $box_l/2.] type 1

#part 0 bond 3 [expr $n_part+1]
#part [expr $n_part] bond 3 [expr $n_part+2]
#part 0 bond 2 [expr $n_part + 1] 1
#part $n_part bond 2 [expr $n_part - 1] [expr $n_part + 2]

part 0 fix 1 1 1
#part [expr $n_part+2] fix 1 1 1

set i 0 

set pos1_id [observable new particle_positions id [expr $n_part+1]]
set force1_id [observable new particle_forces id [expr $n_part+1]]
set v1_id [observable new particle_velocities id [expr $n_part+1]]
set pos_mid_id [observable new particle_positions id [expr $n_part/2]]
set pos_all_id [observable new particle_positions all]

set obs [open $filename "w"]


set NumSteps [expr int(abs(0.5*$Smax*$L_MT/$dx))]


while { $i < [expr $NumSteps]} {
	#print observables after relaxation!
	set pos1 [observable $pos1_id print]
	set v1 [observable $v1_id print]
	set force1 [observable $force1_id print]
	set pos_mid [observable $pos_mid_id print]
	set pos_all [observable $pos_all_id print]
	
	set bendingenergy1 ""
	for {set k 2} { $k < $n_part } {incr k} {
		append bendingenergy1 "[expr [bond_angle [expr $k-1] $k [expr $k+1]] - [PI]] "
	}
	
    puts $obs "[lindex $force1 0] [expr [lindex $pos1 0] - $pos_left] [lindex $pos_mid 1] [analyze energy total] [analyze energy kinetic] [analyze energy bonded 0] [analyze energy bonded 1] [analyze energy bonded 2] [analyze energy bonded 4] $bendingenergy1"
    flush $obs
	part [expr $n_part+1] unfix
	part [expr $n_part+1] pos [expr $pos_right0 - $dx * $i* abs($Smax)/$Smax] [expr $box_l/2. - $bead_size] 0.5
	part [expr $n_part+1] fix
	
	set j 0
#	if {$i == 9 || $i == 150} {
			while {$j < 1} {	
				integrate [expr $nsteps]
				incr j
				}
#			} else {
#	integrate $nsteps
#	}

	incr i
}

close $obs

set tend [setmd time]

puts "time: [expr $tend-$tstart] seed: $Seeds"
